/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.peripheral.platform_specific.PeripheralModEntry;
import qouteall.imm_ptl.peripheral.wand.ClientPortalWandPortalCopy;
import qouteall.imm_ptl.peripheral.wand.ClientPortalWandPortalCreation;
import qouteall.imm_ptl.peripheral.wand.ClientPortalWandPortalDrag;
import qouteall.imm_ptl.peripheral.wand.PortalWandInteraction;

public class PortalWandItem
extends Item {
    private static boolean instructionInformed = false;

    public static void init() {
    }

    public static void initClient() {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT) {
                if (event.player != null) {
                    ItemStack itemStack = event.player.m_21205_();
                    if (itemStack.m_41720_() == PeripheralModEntry.PORTAL_WAND.get()) {
                        PortalWandItem.updateDisplay(itemStack);
                    } else {
                        ClientPortalWandPortalCreation.clearCursorPointing();
                    }
                }
                ClientPortalWandPortalDrag.tick();
            }
        });
        IPGlobal.clientCleanupSignal.connect(ClientPortalWandPortalCreation::reset);
        IPGlobal.clientCleanupSignal.connect(ClientPortalWandPortalDrag::reset);
        IPGlobal.clientCleanupSignal.connect(ClientPortalWandPortalCopy::reset);
    }

    public PortalWandItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onClientLeftClick(LocalPlayer player, ItemStack itemStack) {
        if (player.m_6144_()) {
            PortalWandItem.showSettings((Player)player);
        } else {
            Mode mode = Mode.fromTag(itemStack.m_41784_());
            switch (mode) {
                case CREATE_PORTAL: {
                    ClientPortalWandPortalCreation.onLeftClick();
                    break;
                }
                case DRAG_PORTAL: {
                    ClientPortalWandPortalDrag.onLeftClick();
                    break;
                }
                case COPY_PORTAL: {
                    ClientPortalWandPortalCopy.onLeftClick();
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Mode mode = Mode.fromTag(itemStack.m_41784_());
        if (player.m_6144_() && !world.m_5776_() && !PortalWandInteraction.isDragging((ServerPlayer)player)) {
            Mode nextMode = mode.next();
            itemStack.m_41751_(nextMode.toTag());
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        if (!player.m_6144_() && world.m_5776_()) {
            this.onUseClient(mode);
        }
        return super.m_7203_(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onUseClient(Mode mode) {
        switch (mode) {
            case CREATE_PORTAL: {
                ClientPortalWandPortalCreation.onRightClick();
                break;
            }
            case DRAG_PORTAL: {
                ClientPortalWandPortalDrag.onRightClick();
                break;
            }
            case COPY_PORTAL: {
                ClientPortalWandPortalCopy.onRightClick();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        tooltip.add((Component)Component.m_237110_((String)"imm_ptl.wand.item_desc_1", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.m_90863_(), Minecraft.m_91087_().f_91066_.f_92095_.m_90863_()}));
        tooltip.add((Component)Component.m_237110_((String)"imm_ptl.wand.item_desc_2", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.m_90863_(), Minecraft.m_91087_().f_91066_.f_92096_.m_90863_()}));
    }

    public Component m_7626_(ItemStack stack) {
        Mode mode = Mode.fromTag(stack.m_41784_());
        MutableComponent baseText = Component.m_237115_((String)"item.immersive_portals.portal_wand");
        return baseText.m_7220_((Component)Component.m_237113_((String)" : ")).m_7220_((Component)mode.getText().m_130940_(ChatFormatting.GOLD));
    }

    public static void showSettings(Player player) {
        player.m_213846_((Component)Component.m_237115_((String)"imm_ptl.wand.settings_1"));
        player.m_213846_((Component)Component.m_237115_((String)"imm_ptl.wand.settings_alignment"));
        int[] alignments = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 16, 32, 64};
        ArrayList<MutableComponent> alignmentSettingTexts = new ArrayList<MutableComponent>();
        for (int alignment : alignments) {
            MutableComponent textWithCommand = IPMcHelper.getTextWithCommand(Component.m_237113_((String)("1/" + alignment)), "/imm_ptl_client_debug wand set_cursor_alignment " + alignment);
            alignmentSettingTexts.add(textWithCommand);
        }
        alignmentSettingTexts.add(IPMcHelper.getTextWithCommand(Component.m_237115_((String)"imm_ptl.wand.no_alignment"), "/imm_ptl_client_debug wand set_cursor_alignment 0"));
        player.m_213846_((Component)alignmentSettingTexts.stream().reduce(Component.m_237113_((String)""), (a, b) -> a.m_130946_(" ").m_7220_((Component)b)));
        player.m_213846_((Component)Component.m_237110_((String)"imm_ptl.wand.settings_2", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92098_.m_90863_()}));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateDisplay(ItemStack itemStack) {
        Mode mode = Mode.fromTag(itemStack.m_41784_());
        switch (mode) {
            case CREATE_PORTAL: {
                ClientPortalWandPortalCreation.updateDisplay();
                break;
            }
            case DRAG_PORTAL: {
                ClientPortalWandPortalDrag.updateDisplay();
                break;
            }
            case COPY_PORTAL: {
                ClientPortalWandPortalCopy.updateDisplay();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientRender(LocalPlayer player, ItemStack itemStack, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double camX, double camY, double camZ) {
        if (!instructionInformed) {
            instructionInformed = true;
        }
        CompoundTag tag = itemStack.m_41784_();
        Mode mode = Mode.fromTag(tag);
        switch (mode) {
            case CREATE_PORTAL: {
                ClientPortalWandPortalCreation.render(poseStack, bufferSource, camX, camY, camZ);
                break;
            }
            case DRAG_PORTAL: {
                ClientPortalWandPortalDrag.render(poseStack, bufferSource, camX, camY, camZ);
                break;
            }
            case COPY_PORTAL: {
                ClientPortalWandPortalCopy.render(poseStack, bufferSource, camX, camY, camZ);
            }
        }
    }

    public static enum Mode {
        CREATE_PORTAL,
        DRAG_PORTAL,
        COPY_PORTAL;


        public static Mode fromTag(CompoundTag tag) {
            String mode;
            return switch (mode = tag.m_128461_("mode")) {
                case "create_portal" -> CREATE_PORTAL;
                case "drag_portal" -> DRAG_PORTAL;
                case "copy_portal" -> COPY_PORTAL;
                default -> CREATE_PORTAL;
            };
        }

        public Mode next() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case CREATE_PORTAL -> DRAG_PORTAL;
                case DRAG_PORTAL -> COPY_PORTAL;
                case COPY_PORTAL -> CREATE_PORTAL;
            };
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            String modeString = switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case CREATE_PORTAL -> "create_portal";
                case DRAG_PORTAL -> "drag_portal";
                case COPY_PORTAL -> "copy_portal";
            };
            tag.m_128359_("mode", modeString);
            return tag;
        }

        public MutableComponent getText() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case CREATE_PORTAL -> Component.m_237115_((String)"imm_ptl.wand.mode.create_portal");
                case DRAG_PORTAL -> Component.m_237115_((String)"imm_ptl.wand.mode.drag_portal");
                case COPY_PORTAL -> Component.m_237115_((String)"imm_ptl.wand.mode.copy_portal");
            };
        }
    }
}

